/* global browser */

const removedHeaders = ["access-control-allow-methods", "access-control-allow-headers", "content-security-policy"];
const updatedHeaders = { "access-control-allow-origin": "*", "access-control-allow-credentials": "true" };

browser.webRequest.onHeadersReceived.addListener(
	function (details) {
		let responseHeaders = details.responseHeaders;
		let processedHeaders = [];
		responseHeaders = responseHeaders.filter(responseHeader => !removedHeaders.includes(responseHeader.name.toLowerCase()));
		responseHeaders.forEach(responseHeader => {
			const name = responseHeader.name.toLowerCase();
			const value = updatedHeaders[name];
			if (value) {
				responseHeader.value = value;
				processedHeaders.push(name);
			}
		});
		Object.keys(updatedHeaders).forEach(name => {
			if (!processedHeaders.includes(name)) {
				const value = updatedHeaders[name.toLowerCase()];
				if (value) {
					responseHeaders.push({ name, value });
				}
			}
		});
		return { responseHeaders };
	},
	{ urls: ["<all_urls>"] },
	["blocking", "responseHeaders"]
);